\+DatabaseType MDF 4.0
\ver 5.0
\desc Standard Format markers defined in _Making Dictionaries: A guide to lexicography and the Multi-Dictionary Formatter_. David F. Coward, Charles E. Grimes, and Mark R. Pedrotti. Waxhaw, NC: SIL, 1998. (2nd edition)
\+mkrset 
\lngDefault English
\mkrRecord lx

\+mkr 1d
\nam First dual
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 1e
\nam First plural exclusive
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 1i
\nam First plural inclusive
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 1p
\nam First plural
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 1s
\nam First singular
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 2d
\nam Second dual
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 2p
\nam Second plural
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 2s
\nam Second singular
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 3d
\nam Third dual
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 3p
\nam Third plural
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 3s
\nam Third singular
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 4d
\nam Non-animate dual
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 4p
\nam Non-animate plural
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr 4s
\nam Non-animate singular
\desc Used to give the vernacular for this particular paradigm form. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr a
\nam Alternate for parse
\desc Alternate form of lexeme for use in parsing interlinear text. Not for publication.
\lng vernacular
\mkrOverThis lx
\mkrFollowingThis u
\CharStyle
\-mkr

\+mkr an
\nam Antonym
\desc Used to reference an antonym of the lexeme, but using the \lf (lexical function) field for this is better practice.
\lng vernacular
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr bb
\nam Bibliography
\desc Used to record any bibliographic information pertinent to the lexeme. MDF adds the label 'Read:' to this field. For basic information (to reference an entry in a more complete bibliography database) include the following: AuthorLastName, FirstName/Initials date:pp. For a more complete reference include: AuthorLastName, FirstName/Initials. date. Title. City, Publisher. pp. xxx-yyy.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr bw
\nam Borrowed word (loan)
\desc Used for denoting the source language of a borrowed word.
\lng English
\mkrOverThis se
\CharStyle
\-mkr

\+mkr ce
\nam Cross-ref. gloss (E)
\desc Gives the English gloss(es) for the vernacular lexeme referenced by the preceding \cf field.
\lng English
\mkrOverThis cf
\CharStyle
\-mkr

\+mkr cf
\nam Cross-reference
\desc This is a generic reference marker used to link together any two related entries in the lexicon. The content is a vernacular lexeme. If the relationship is known, the lexical function \lf field is a better way to cross-reference two lexemes.
\lng vernacular
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr cn
\nam Cross-ref. gloss (n)
\desc Gives the national language gloss(es) for the vernacular lexeme referenced by the preceding \cf field.
\lng national
\mkrOverThis cf
\CharStyle
\-mkr

\+mkr cr
\nam Cross-ref. gloss (r)
\desc Gives the regional language gloss(es) for the vernacular lexeme referenced by the preceding \cf field.
\lng national
\mkrOverThis cf
\CharStyle
\-mkr

\+mkr de
\nam Definition (E)
\desc Used to fully express the semantic domains of each sense of a lexeme in English. May be verbose. Other fields (\ee, \ue, and \oe) provide for expanded information. Should contain 1) the bundle of semantic distinctive features necessary and sufficient to describe its core meaning, and 2) the range of denotation of the lexeme. Generally, no initial capital is used.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr dn
\nam Definition (n)
\desc Used to fully express the semantic domains of each sense of a lexeme in the national language. May be verbose. Other fields (\en, \un, and \on) provide for expanded information. Should contain 1) the bundle of semantic distinctive features necessary and sufficient to describe its core meaning, and 2) the range of denotation of the lexeme. Generally, no initial capital is used.
\lng national
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr dr
\nam Definition (r)
\desc Used to fully express the semantic domains of each sense of a lexeme in the regional language. May be verbose. Other fields (\er, \ur, and \or) provide for expanded information. Should contain 1) the bundle of semantic distinctive features necessary and sufficient to describe its core meaning, and 2) the range of denotation of the lexeme. Generally, no initial capital is used.
\lng regional
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr dt
\nam Date (last edited)
\desc A Shoebox bookkeeping field to help keep track of the last time an entry was edited. One per record (usually the last field) is adequate. Usually inserted automatically by Shoebox. The datestamp field is set up under the Shoebox menu option: Database-Properties-Options tab.
\lng Date
\mkrOverThis lx
\CharStyle
\-mkr

\+mkr dv
\nam Definition (v)
\desc The hardest of all fields to fill in. It requires the researcher to explain, in the vernacular, what the salient concepts are that this "unit of meaning" captures -- from a native speaker's perspective. Obviously not easy and something usually left to much later.
\lng vernacular
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr ec
\nam Etymology comment
\desc Any comments the researcher needs to add concerning the etymology of the lexeme can be given here. Not intended for printing.
\lng English
\mkrOverThis et
\CharStyle
\-mkr

\+mkr ee
\nam Encyclopedic info. (E)
\desc This field crosses over with the \de, \ue, and \oe fields, but is intended for more verbose explanations of the headword (for each sense). The researcher should use this field to encode any additional information needed by a non-native speaker to understand and use this lexeme properly. Use capitalization and punctuation as needed.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr eg
\nam Etymology gloss (E)
\desc The published gloss for the etymological reference is given here.
\lng English
\mkrOverThis et
\CharStyle
\-mkr

\+mkr en
\nam Encyclopedic info. (n)
\desc The national language equivalent to the \ee field. It should cover any information that provides a more complete knowledge-base on the lexeme. Use capitalization and punctuation as needed.
\lng national
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr er
\nam Encyclopedic info. (r)
\desc The regional language equivalent to the \ee field. It should cover any information that provides a more complete knowledge-base on the lexeme. Use capitalization and punctuation as needed.
\lng regional
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr es
\nam Etymology source
\desc The reference or source abbreviation for etymology of the lexeme is given here. Use a Range Set.
\lng English
\mkrOverThis et
\CharStyle
\-mkr

\+mkr et
\nam Etymology (proto form)
\desc The etymology for the lexeme is put here, e.g.: \et *babuy
\lng vernacular
\mkrOverThis se
\CharStyle
\-mkr

\+mkr ev
\nam Encyclopedic info. (v)
\desc This field contains the vernacular description of any pertinent encyclopedic information related to the lexeme or headword, subentry, or sense. This is intended for use in a monolingual dictionary, but can be used in diglot and triglot dictionaries as well. Use capitalization and punctuation as needed.
\lng vernacular
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr ge
\nam Gloss (E)
\desc Intended for interlinear morpheme-level glossing. Join multi-word glosses with (_), e.g. wild_boar; use (space semicolon space) for multiple glosses, e.g. hut ; house ; shack. Used for reversing the dictionary if an \re field is not present (or is present but empty); also as an English definition in a formatted dictionary if there is no \de field (or it is present but empty).
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr gn
\nam Gloss (n)
\desc Intended for interlinear morpheme-level glossing. Join multi-word glosses with (_), e.g. wild_boar; use (space semicolon space) for multiple glosses, e.g. hut ; house ; shack. The contents are used for reversing the dictionary if an \rn field is not present (or is present but empty). Also used as a national language definition in a formatted dictionary if there is no \dn field (or it is present but empty).
\lng national
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr gr
\nam Gloss (r)
\desc Intended for interlinear morpheme-level glossing. Join multi-word glosses with (_), e.g. wild_boar; use (space semicolon space) for multiple glosses, e.g. hut ; house ; shack. Since MDF does not create a reversed index for the regional language, this field is not used for this. But the contents of this field are used as a regional language definition in a formatted dictionary if there is no \dr field (or it is present but empty).
\lng regional
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr gv
\nam Gloss (v)
\desc This field is available for developing a monolingual dictionary. While somewhat meaningless (a vernacular gloss for a vernacular word), this is a useful place to store the explanations a researcher is given by a language assistant concerning the meaning of the headword or lexeme. Later these will be formulated into a more exact definition and transfer to the \dv field.
\lng vernacular
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr hm
\nam Homonym number
\desc Used to differentiate homonym entries (lexemes that are spelled the same but have no semantic relationship). This field comes directly after the \lx field and simply contains a number, e.g. 1, 2, or 3, etc. Use a Character Range Set.
\lng English
\mkrOverThis lx
\CharStyle
\-mkr

\+mkr is
\nam Index of semantics
\desc Used to catalog lexical entries according to an etic (published) list of possible semantic domains. Sorting on this field would then gather semantically related entries. Use a Range Set.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr lc
\nam Citation form
\desc This should be added only if the lexical entry form is inappropriate for the printed dictionary, and you want to substitute another form for the printed entry. When formatting a document, MDF always replaces the contents of the \lx field with the contents of the \lc field (if present).
\lng vernacular
\mkrOverThis lx
\CharStyle
\-mkr

\+mkr le
\nam Lexical function gloss (E)
\desc This is for giving the English gloss of the vernacular lexeme referenced by the lexical function.
\lng English
\mkrOverThis lv
\CharStyle
\-mkr

\+mkr lf
\nam Lexical function label
\desc Used to encode the semantic networks of a language. For consistency, a Range Set should be maintained on the lexical function labels used. When formatted by MDF, these labels can be modified (and even translated) by MDF's Audience CC tables.
\lng English
\+fnt 
\Name Times New Roman
\Size 11
\Italic
\rgbColor 0,0,0
\-fnt
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr ln
\nam Lexical function gloss (n)
\desc This is for giving the national language gloss of the vernacular lexeme referenced by the lexical function.
\lng national
\mkrOverThis lv
\CharStyle
\-mkr

\+mkr lr
\nam Lexical function gloss (r)
\desc This is for giving the regional language gloss of the vernacular lexeme referenced by the lexical function.
\lng regional
\mkrOverThis lv
\CharStyle
\-mkr

\+mkr lt
\nam Literally
\desc Used to elucidate the distinct meanings of the parts of an idiom or complex phrase in a lexical entry (\lx) or subentry (\se).
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr lv
\nam Lexical function value
\desc Used for the vernacular lexeme in a lexical function network. The \lv field "points to" the vernacular lexeme (a morpheme, word, or phrase) that is semantically related to the current headword as mapped or cataloged by the label in the \lf field.
\lng vernacular
\mkrOverThis lf
\CharStyle
\-mkr

\+mkr lx
\nam Lexeme
\desc The Record marker for each record in a lexical entry. It contains the lexeme or headword (which is commonly mono-morphemic). Since such a lexeme form is often not accessible for vernacular speakers if printed, use the \lc field to provide a more readable form for vernacular speakers.
\lng vernacular
\-mkr

\+mkr mn
\nam Main entry cross-ref.
\desc Used to reference a minimal entry back to its main entry.
\lng vernacular
\mkrOverThis se
\CharStyle
\-mkr

\+mkr mr
\nam Morphology
\desc Used to show the underlying morphemic structure for complex lexemes.
\lng vernacular
\mkrOverThis se
\CharStyle
\-mkr

\+mkr na
\nam Notes (anthropology)
\desc For any ethnographic note pertinent to the lexeme that you want separate from general notes. Capitalization and punctuation should be used as needed.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr nd
\nam Notes (discourse)
\desc For any discourse/text analysis note pertinent to the lexeme that you want separate from general notes. Capitalization and punctuation should be used as needed.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr ng
\nam Notes (grammar)
\desc For any grammar note pertinent to the lexeme that you want separate from general notes. Capitalization and punctuation should be used as needed.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr np
\nam Notes (phonology)
\desc For any phonology note pertinent to the lexeme that you want separate from general notes. Capitalization and punctuation should be used as needed.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr nq
\nam Notes (questions)
\desc For any question or note for further study, pertinent to the lexeme, that you want separate from general notes. Capitalization and punctuation should be used as needed.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr ns
\nam Notes (sociolinguistics)
\desc For any sociolinguistics note pertinent to the lexeme that you want separate from general notes. Capitalization and punctuation should be used as needed.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr nt
\nam Notes (general)
\desc A generic dump for all personal notes about an entry, subentry, or sense. More specific note fields provide a finer differentiation to one's notes: \np (phonology), \ng (grammar), \nd (discourse), \na (anthropology), \ns (sociolinguistics), and \nq (questions). All "note fields" should use capitalization and punctuation as needed.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr oe
\nam Only/restrictions (E)
\desc For denoting in English any semantic and/or grammatical restrictions pertinent to the lexeme. Use capitalization and punctuation as needed.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr on
\nam Only/restrictions (n)
\desc For denoting in the national language any semantic and/or grammatical restrictions pertinent to the lexeme. Use capitalization and punctuation as needed.
\lng national
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr or
\nam Only/restrictions (r)
\desc For denoting in the regional language any semantic and/or grammatical restrictions pertinent to the lexeme. Use capitalization and punctuation as needed.
\lng regional
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr ov
\nam Only/restrictions (v)
\desc This field contains the vernacular description of any semantic and/or grammatical restrictions pertinent to the lexeme or headword. This is intended for use in a monolingual dictionary, but can be used in diglot and triglot dictionaries as well. Use capitalization and punctuation as needed.
\lng vernacular
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr pc
\nam Picture
\desc This contains either the book and page number reference of a relevant picture (either sketched in a notebook or found in a picture book), or a link to the graphics file of a picture you want to include in your printed dictionary (see MDF documentation for how to create a link).
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr pd
\nam Paradigm
\desc Used for specifying the noun or verb class, gender, or other paradigm set that the lexeme or headword is associated with. These classes are generally given labels or numbers to differentiate them. Use the Range Set feature for consistency.
\lng English
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr pde
\nam Paradigm form gloss (E)
\desc Used for glossing the vernacular paradigm form in English.
\lng English
\mkrOverThis pdl
\CharStyle
\-mkr

\+mkr pdl
\nam Paradigm label
\desc Used to label the paradigm form given in the \pdv field. This is useful for paradigm sets that are incomplete or irregular. Use a Range Set.
\lng English
\+fnt 
\Name Times New Roman
\Size 11
\Italic
\rgbColor 0,0,0
\-fnt
\mkrOverThis pd
\CharStyle
\-mkr

\+mkr pdn
\nam Paradigm form gloss (n)
\desc Used for glossing the vernacular paradigm form in the national language.
\lng national
\mkrOverThis pdl
\CharStyle
\-mkr

\+mkr pdr
\nam Paradigm form gloss (r)
\desc Used for glossing the vernacular paradigm form in the regional language.
\lng regional
\mkrOverThis pdl
\CharStyle
\-mkr

\+mkr pdv
\nam Paradigm form
\desc Used to give the vernacular paradigm form specified by the label in the \pdl field. Used mostly for irregular or incomplete paradigm sets.
\lng vernacular
\mkrOverThis pdl
\CharStyle
\-mkr

\+mkr ph
\nam Phonetic form
\desc Used as needed to retain the phonetic information that is lost when an orthographic spelling is used for an entry. Can follow \lx or \se.  Details on how to interpret symbols in this field should be included in pronunciation guide.
\lng phonetic
\mkrOverThis se
\CharStyle
\-mkr

\+mkr pl
\nam Plural form
\desc This is a special paradigm field used to give the plural form of the lexeme. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr pn
\nam Part of speech (n)
\desc Classifies the part of speech with labels found in national language dictionaries. If used, this comes after the \ps field. Consistent labeling is important; use the Range Set feature.
\lng national
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr ps
\nam Part of speech
\desc Classifies the part of speech. This must reflect the part of speech of the vernacular lexeme (not the national or English gloss). Consistent labeling is important; use the Range Set feature. Sense numbers are beneath \ps in this hierarchy; don't mark different \ps fields with sense numbers.
\lng English
\+fnt 
\Name Times New Roman
\Size 11
\Italic
\rgbColor 0,0,0
\-fnt
\mkrOverThis se
\CharStyle
\-mkr

\+mkr rd
\nam Reduplication form(s)
\desc A repository for reduplication forms for later study (these forms should be moved to subentries, etc. as more is known about them).
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr re
\nam Reversal (E)
\desc English word(s)/phrase(s); used to reverse the dictionary for an English index. If no \re field is given, the \ge field is used. If an \re * is present, the relevant entry, subentry, or sense will not be included in the reversed index. Put {space semicolon space} between multiple items, e.g. hut ; house.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr rf
\nam Reference
\desc Used to note the reference for the following example sentence.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr rn
\nam Reversal (n)
\desc National language word(s)/phrase(s); used to reverse the dictionary for a national audience index. If no \rn field is given, the \gn field is used. If an \rn * is present, the relevant entry, subentry, or sense will not be included in the reversed index. Put {space semicolon space} between multiple items, e.g. hut ; house.
\lng national
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr rr
\nam Reversal (r)
\desc Regional language word or phrase that could be used to reverse the dictionary for a regional audience. Currently MDF does not support exporting a regional audience index.
\lng regional
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr sc
\nam Scientific name
\desc Used to provide a scientific name for a lexeme.
\lng English
\+fnt 
\Name Times New Roman
\Size 11
\Italic
\Underline
\rgbColor 0,0,0
\-fnt
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr sd
\nam Semantic domain
\desc The English version of the \th field and probably the one to use first. Differentiate and catalog the semantic domains of an entry, being careful to not let the English force or mask the vernacular relations. Moving to the vernacular terms (given in \th field) as early as possible is best. Use a Range Set.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr se
\nam Subentry
\desc Like the \lx field except it occurs within the record, marking a word (or phrase) as a form derived from the root. Following this marker would be all the fields that comprise a typical lexical entry. There can be several of these subentries within a record. Subentries can have multiple senses (in this hierarchy).
\lng vernacular
\+fnt 
\Name Times New Roman
\Size 12
\Bold
\rgbColor 0,0,0
\-fnt
\mkrOverThis lx
\-mkr

\+mkr sg
\nam Singular form
\desc This is a special paradigm field used to give the singular form of the lexeme. (It is better to use the \pdl field set for this.)
\lng vernacular
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr sn
\nam Sense number
\desc Where a lexeme has more than one sense, this code is used to mark and number mark the beginning of each section that discusses a new sense. Don't use a sense number to mark a different part of speech; \sn is only used within a given part of speech (in this hierarchy). (Remember to include \sn 1 for records with multiple senses.) Use a Character Range Set.
\lng English
\mkrOverThis ps
\CharStyle
\-mkr

\+mkr so
\nam Source
\desc Used to indicate the name and village of the informant who provided the data in the current entry.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr st
\nam Status
\desc Used to indicate how complete or thoroughly checked an entry is. Use a Range Set.
\lng English
\mkrOverThis lx
\CharStyle
\-mkr

\+mkr sy
\nam Synonym
\desc Used to reference a synonym of the lexeme, but using the \lf (lexical function) field for this is better practice.
\lng vernacular
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr tb
\nam Table
\desc This field allows for a table or tabulated information to be added to the dictionary.
\lng English
\NoWordWrap
\mkrOverThis sn
\-mkr

\+mkr th
\nam Thesaurus
\desc Used for developing a vernacular-based thesaurus. It is to be labeled with the vernacular term governing the semantic domain of the entry. Sorting on this field (within Shoebox) would yield a vernacular thesaurus. Use a Range Set.
\lng vernacular
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr u
\nam Underlying for parse
\desc Underlying form for use in parsing interlinear text. Not for publication.
\lng vernacular
\mkrOverThis lx
\CharStyle
\-mkr

\+mkr ue
\nam Usage (E)
\desc This field should cover, in English, such information as common usage, or restrictions in usage (such as taboos) that is needed so a non-native speaker can use this lexeme properly. Use capitalization and punctuation as needed.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr un
\nam Usage (n)
\desc This field should cover, in the national language, such information as common usage, or restrictions in usage (such as taboos) that is needed so a non-native speaker can use this lexeme properly. Use capitalization and punctuation as needed.
\lng national
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr ur
\nam Usage (r)
\desc This field should cover, in the regional language, such information as common usage, or restrictions in usage (such as taboos) that is needed so a non-native speaker can use this lexeme properly. Use capitalization and punctuation as needed.
\lng regional
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr uv
\nam Usage (v)
\desc This field contains the vernacular description of common usage, or restrictions in usage (such as taboos) that is needed to describe the lexeme more fully. Intended for use in a monolingual dictionary, but can be used in diglot and triglot dictionaries as well. Use capitalization and punctuation as needed.
\lng vernacular
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr va
\nam Variant form(s)
\desc Where variant forms of the lexical entry or subentry can be noted (e.g. forms from another dialect or minor alternations in the focus dialect). Usually these forms occur elsewhere in the dictionary as minor entries. Comments on this field are given with the \ve, \vn, and \vr fields.
\lng vernacular
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr ve
\nam Variant comment (E)
\desc Where English comments can be given for the variant form.
\lng English
\mkrOverThis va
\CharStyle
\-mkr

\+mkr vn
\nam Variant comment (n)
\desc Where national language comments can be given for the variant form.
\lng national
\mkrOverThis va
\CharStyle
\-mkr

\+mkr vr
\nam Variant comment (r)
\desc Where regional language comments can be given for the variant form.
\lng regional
\mkrOverThis va
\CharStyle
\-mkr

\+mkr we
\nam Word-level gloss (E)
\desc English gloss to be used in word-level interlinear glossing.
\lng English
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr wn
\nam Word-level gloss (n)
\desc National language gloss to be used in word-level interlinear glossing.
\lng national
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr wr
\nam Word-level gloss (r)
\desc Regional language gloss to be used in word-level interlinear glossing.
\lng regional
\mkrOverThis sn
\CharStyle
\-mkr

\+mkr xe
\nam Example free trans. (E)
\desc English translation of the example sentence given in the \xv field. Use capitalization and punctuation as needed.
\lng English
\mkrOverThis xv
\CharStyle
\-mkr

\+mkr xn
\nam Example free trans. (n)
\desc National language translation of the example sentence given in the \xv field. Use capitalization and punctuation as needed.
\lng national
\mkrOverThis xv
\CharStyle
\-mkr

\+mkr xr
\nam Example free trans. (r)
\desc Regional language translation of the example sentence given in the \xv field. Use capitalization and punctuation as needed.
\lng regional
\mkrOverThis xv
\CharStyle
\-mkr

\+mkr xv
\nam Example (v)
\desc Used to give an example or illustrative sentence in the vernacular to exemplify each separate sense and demonstrate legitimacy of translation equivalents. Should be short and natural. Use capitalization and punctuation as needed.
\lng vernacular
\mkrOverThis rf
\mkrFollowingThis xe
\CharStyle
\-mkr

\+mkr u
\lng English
\mkrOverThis lx
\-mkr

\-mkrset

\iInterlinCharWd 10
\+filset 

\+fil Affixes
\mkr lx
\txt -
\match_char i
\-fil

\-filset

\+jmpset 
\-jmpset

\+template 
\fld \ps
\fld \ge
\-template
\mkrRecord lx
\mkrSecKey hm
\mkrDateStamp dt
\mkrMultipleMatchShow ge
\+PrintProperties 
\header File: &f, Date: &d
\footer Page &p
\topmargin 1.00 in
\leftmargin 0.25 in
\bottommargin 1.00 in
\rightmargin 0.25 in
\recordsspace 100
\-PrintProperties
\+expset 
\MDF
\verMDF 4.1

\+expMDF Multi-Dictionary Formatter
\UTF8
\copyright Copyright  2002
\titleEnglishDiglot Selaru  English Dictionary
\titleEnglishTriglot Selaru  English  Indonesian Dictionary
\titleGlossIndexEE English  Selaru
\titleGlossIndexEN Indonesian  Selaru
\titleGlossIndexER Ambonese Malay  Selaru
\titleNationalDiglot Kamus Bahasa Selaru  Bahasa Indonesia
\titleNationalTriglot Kamus Bahasa Selaru  Bahasa Indonesia  Bahasa Ingris
\titleGlossIndexNE Bahasa Ingris  Bahasa Selaru
\titleGlossIndexNN Bahasa Indonesia  Bahasa Selaru
\titleGlossIndexNR Bahasa Ambon  Bahasa Selaru
\cctEnglishLabels mdf_eng.cct
\dotEnglish mdf_e.dot
\cctNationalLabels mdf_inz.cct
\dotNational mdf_n.dot
\typRTF MDF Rich Text Format
\typHTML MDF SF-to-HTML
\+mkrsubsetExcluded 
\mkr dt
\mkr ec
\mkr es
\mkr is
\mkr re
\mkr rn
\mkr rr
\mkr sd
\mkr so
\mkr st
\mkr th
\mkr we
\mkr wn
\mkr wr
\-mkrsubsetExcluded
\+rtfPageSetup 
\paperSize letter
\topMargin 0.75
\bottomMargin 1.25
\leftMargin 0.75
\rightMargin 0.75
\gutter 0.5
\headerToEdge 0.375
\footerToEdge 0.875
\columns 2
\columnSpacing 0.25
\-rtfPageSetup
\-expMDF

\+expRTF Rich Text Format
\+rtfPageSetup 
\paperSize letter
\topMargin 1
\bottomMargin 1
\leftMargin 1.25
\rightMargin 1.25
\gutter 0
\headerToEdge 0.5
\footerToEdge 0.5
\columns 1
\columnSpacing 0.5
\-rtfPageSetup
\-expRTF

\+expSF Standard Format
\-expSF

\expDefault Multi-Dictionary Formatter
\AutoOpen
\-expset
\PreventNumbering
\DisableNumbering
\-DatabaseType
